function [info] = runprob(pname)
%====================================================================
% Purpose : Solve a test problem using the solver fPlusL1.
%====================================================================
%
% Input:
%    pname: name of the problem being solving. 
%====================================================================
dir = '../datasets/libsvm/';
%dir = 'D:/Data/';

%Load the problem
probLoad = sprintf([dir,pname,'.mat']);

load(probLoad);

%Load parameter settings
parms = proxsg_fp_mixed_l1l2_spec;
%parms.batch_size = min([256, floor(0.01 * size(X, 1))]);
norm_square_samples = vecnorm(X') .^ 2;
L = max(norm_square_samples) / 4.0;
parms.alpha = 1 / L; 

% Choose weighting parameter, set objective function.
%lambda = 100/size(X,1); % Need to look into this.
% lambda = 1e-3; % Need to look into this.
groups = split_groups_new(size(X, 2), parms.num_groups);
% lam_max = lamMax(X, y, groups, parms.num_groups, 'logit')

% lambda = lam_max * 1;
lambda = 1e-4;

% Get the lossfunction by X,y.
funObj = lossfunction.LogRegCost(X,y);

% Solve the problem.
info = proxsg_fp_mixed_l1l2_solver(pname,funObj,lambda,parms);

return
